/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskCFSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskSharedStorageAccess;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskCFSIntegrity {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    static final String LSEP = System.getProperty("line.separator");
    private TaskCFSIntegrity m_genTask;
    private boolean m_OCFS2 = sStorageUtil.isOCFS2supported();
    private String m_absOcfsConf = this.m_OCFS2 ? "/etc/ocfs2/cluster.conf" : "/etc/ocfs.conf";
    private String chkcfgcmd = this.m_OCFS2 ? "/sbin/chkconfig --list ocfs2" : "/sbin/chkconfig --list ocfs";
    private String guidcmd = "grep guid /etc/ocfs.conf";

    public sTaskCFSIntegrity(TaskCFSIntegrity genTask) {
        this.m_genTask = genTask;
    }

    public boolean performCheck() {
        String key;
        Iterator iterator;
        ErrorDescription errorDesc;
        String[] outList;
        String curNode;
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4500", false));
        ReportUtil.sureblankln();
        GlobalExecution globalExec = new GlobalExecution();
        Hashtable ht = null;
        Enumeration e = null;
        Vector<String> notRunVec = new Vector<String>();
        ResultSet confRSet = new ResultSet();
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4516", false, (Object[])new String[]{this.m_absOcfsConf}));
        globalExec.checkFileExistence(this.m_genTask.m_nodeList, this.m_absOcfsConf, confRSet);
        ht = confRSet.getResultTable();
        e = ht.keys();
        Vector<String> noConfVec = new Vector<String>();
        while (e.hasMoreElements()) {
            ErrorDescription errorDesc2;
            String curNode2 = (String)e.nextElement();
            Trace.out((String)("==== Analyzing configuration file chk result for node " + curNode2));
            Result result = (Result)ht.get(curNode2);
            if (result != null && 3 == result.getStatus()) {
                Trace.out((String)("==== configuration file is missing for " + curNode2));
                noConfVec.add(curNode2);
                errorDesc2 = new ErrorDescription(s_msgBundle.getMessage("4527", false, (Object[])new String[]{this.m_absOcfsConf, curNode2}));
                confRSet.addErrorDescription(curNode2, errorDesc2);
                continue;
            }
            if (result != null && 1 == result.getStatus()) continue;
            Trace.out((String)("==== configuration file chk did not run on " + curNode2));
            notRunVec.add(curNode2);
            errorDesc2 = new ErrorDescription(s_msgBundle.getMessage("4528", true, (Object[])new String[]{this.m_absOcfsConf, curNode2}), s_msgBundle, "4528");
            confRSet.addErrorDescription(curNode2, errorDesc2);
        }
        if (notRunVec.isEmpty() && noConfVec.isEmpty()) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("4517", false, (Object[])new String[]{this.m_absOcfsConf}));
        } else {
            if (!noConfVec.isEmpty()) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("4518", false, (Object[])new String[]{this.m_absOcfsConf}));
                ReportUtil.sureprintNodelist(noConfVec);
            }
            if (!notRunVec.isEmpty()) {
                ReportUtil.reportNotRunList(notRunVec);
            }
            ReportUtil.sureprintln(s_msgBundle.getMessage("4519", false, (Object[])new String[]{this.m_absOcfsConf}));
        }
        Trace.out((String)"==== Uploading results from confRSet");
        this.m_genTask.m_resultSet.uploadResultSet(confRSet);
        if (!this.m_OCFS2) {
            ResultSet guidRSet = new ResultSet();
            notRunVec.clear();
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4520", false));
            Trace.out((String)("==== grepguid command: " + this.guidcmd));
            Hashtable guidOutputHT = globalExec.runExeWithOutput(this.m_genTask.m_nodeList, this.guidcmd, guidRSet);
            Trace.out((String)"==== Initial update from guidRSet");
            this.m_genTask.m_resultSet.uploadResultSet(guidRSet);
            HashMap<String, String> unqGuidHM = new HashMap<String, String>(this.m_genTask.m_nodeList.length);
            HashMap<String, Vector<String>> sameGuidHM = new HashMap<String, Vector<String>>();
            ht = guidRSet.getResultTable();
            e = ht.keys();
            while (e.hasMoreElements()) {
                curNode = (String)e.nextElement();
                Trace.out((String)("==== Analyzing guid for node " + curNode));
                Result result = (Result)ht.get(curNode);
                if (result.getStatus() == 1) {
                    outList = (String[])result.getResultInfoSet().firstElement();
                    String hostGuid = null;
                    if (outList == null || outList.length == 0 || outList[0].trim().length() == 0) {
                        Trace.out((String)("==== GUID retrieve for " + curNode + " is null or empty. Setting it to null."));
                        hostGuid = null;
                    } else {
                        hostGuid = this.getHostGuid(outList[0]);
                        Trace.out((String)("==== Hostguid for node " + curNode + " is: " + hostGuid));
                    }
                    if (unqGuidHM.containsKey(hostGuid) || hostGuid == null || hostGuid.trim().length() == 0) {
                        Vector<String> vNdWithSameGuid = (Vector<String>)sameGuidHM.get(hostGuid);
                        if (vNdWithSameGuid == null) {
                            vNdWithSameGuid = new Vector<String>();
                            String prevGuidEntry = (String)unqGuidHM.get(hostGuid);
                            Trace.out((String)("==== Existing node with this guid is: " + prevGuidEntry));
                            if (prevGuidEntry != null && prevGuidEntry.trim().length() != 0) {
                                vNdWithSameGuid.add(new String(prevGuidEntry));
                                this.m_genTask.getResultSet().addResult(prevGuidEntry, 2);
                                ErrorDescription errorDesc3 = new ErrorDescription(s_msgBundle.getMessage("4529", true, (Object[])new String[]{prevGuidEntry}), s_msgBundle, "4529");
                                this.m_genTask.getResultSet().addErrorDescription(prevGuidEntry, errorDesc3);
                            }
                            vNdWithSameGuid.add(new String(curNode));
                        } else {
                            vNdWithSameGuid.add(new String(curNode));
                        }
                        sameGuidHM.put(hostGuid, vNdWithSameGuid);
                        Trace.out((String)("==== Duplicate hostguid for node " + curNode));
                        this.m_genTask.getResultSet().addResult(curNode, 2);
                        errorDesc = new ErrorDescription(s_msgBundle.getMessage("4529", false, (Object[])new String[]{curNode}));
                        this.m_genTask.getResultSet().addErrorDescription(curNode, errorDesc);
                        continue;
                    }
                    unqGuidHM.put(hostGuid, curNode);
                    continue;
                }
                Trace.out((String)("==== GUID check failed for node " + curNode));
                this.m_genTask.getResultSet().addResult(curNode, 2);
                notRunVec.add(curNode);
            }
            if (sameGuidHM.isEmpty() && notRunVec.isEmpty()) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("4521", false));
            } else {
                if (!sameGuidHM.isEmpty()) {
                    iterator = sameGuidHM.keySet().iterator();
                    int count = 0;
                    while (iterator.hasNext()) {
                        ++count;
                        key = (String)iterator.next();
                        Vector vec = (Vector)sameGuidHM.get(key);
                        if (vec == null) {
                            Trace.out((String)("==== Member with same guid data missing for key " + key));
                            continue;
                        }
                        ReportUtil.blankln();
                        ReportUtil.println(s_msgBundle.getMessage("4522", false));
                        ReportUtil.printNodelist(vec);
                    }
                }
                if (!notRunVec.isEmpty()) {
                    ReportUtil.reportNotRunList(notRunVec);
                }
                ReportUtil.sureprintln(s_msgBundle.getMessage("4523", false));
            }
        }
        notRunVec.clear();
        ReportUtil.sureblankln();
        if (this.m_OCFS2) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("9304", false));
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("4524", false));
        }
        boolean rlvlChkFailed = false;
        ResultSet rlvlRSet = new ResultSet();
        Trace.out((String)("==== chkconfig command: " + this.chkcfgcmd));
        Hashtable runLvlChkOutputHT = globalExec.runExeWithOutput(this.m_genTask.m_nodeList, this.chkcfgcmd, rlvlRSet);
        Trace.out((String)"==== Initial update from rlvlRSet");
        this.m_genTask.m_resultSet.uploadResultSet(rlvlRSet);
        HashMap<String, String[]> indRunLvlHM = new HashMap<String, String[]>();
        ht = rlvlRSet.getResultTable();
        e = ht.keys();
        while (e.hasMoreElements()) {
            curNode = (String)e.nextElement();
            Trace.out((String)("==== Analyzing chkconfig output for node " + curNode));
            Result result = (Result)ht.get(curNode);
            if (result.getStatus() == 1) {
                String[] cfgRes;
                outList = (String[])result.getResultInfoSet().firstElement();
                String rawData = outList == null || outList.length == 0 ? "" : outList[0];
                if (!this.checkRunLevel(rawData, cfgRes = new String[3])) {
                    rlvlChkFailed = true;
                    this.m_genTask.getResultSet().addResult(curNode, 2);
                    errorDesc = null;
                    errorDesc = this.m_OCFS2 ? new ErrorDescription(s_msgBundle.getMessage("9310", true, (Object[])new String[]{curNode}), s_msgBundle, "9310") : new ErrorDescription(s_msgBundle.getMessage("4530", true, (Object[])new String[]{curNode}), s_msgBundle, "4530");
                    this.m_genTask.getResultSet().addErrorDescription(curNode, errorDesc);
                }
                indRunLvlHM.put(curNode, cfgRes);
                continue;
            }
            Trace.out((String)("==== chkconfig check failed for node " + curNode));
            this.m_genTask.getResultSet().addResult(curNode, 2);
            ErrorDescription errorDesc4 = null;
            errorDesc4 = this.m_OCFS2 ? new ErrorDescription(s_msgBundle.getMessage("9311", false, (Object[])new String[]{curNode})) : new ErrorDescription(s_msgBundle.getMessage("4531", false, (Object[])new String[]{curNode}));
            this.m_genTask.getResultSet().addErrorDescription(curNode, errorDesc4);
            notRunVec.add(curNode);
        }
        if (!rlvlChkFailed && notRunVec.isEmpty()) {
            if (this.m_OCFS2) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("9305", false));
            } else {
                ReportUtil.sureprintln(s_msgBundle.getMessage("4525", false));
            }
        } else {
            if (rlvlChkFailed) {
                ReportUtil.blankln();
                ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.RUNLEVEL + ":3", ReportUtil.RUNLEVEL + ":4", ReportUtil.RUNLEVEL + ":5");
                iterator = indRunLvlHM.keySet().iterator();
                int count = 0;
                while (iterator.hasNext()) {
                    ++count;
                    key = (String)iterator.next();
                    String[] indRes = (String[])indRunLvlHM.get(key);
                    if (indRes == null) {
                        Trace.out((String)("==== Run level data missing for key " + key));
                        continue;
                    }
                    ReportUtil.writeRecord(key, indRes[0], indRes[1], indRes[2]);
                }
            }
            if (!notRunVec.isEmpty()) {
                ReportUtil.reportNotRunList(notRunVec);
            }
            if (this.m_OCFS2) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("9306", false));
            } else {
                ReportUtil.sureprintln(s_msgBundle.getMessage("4526", false));
            }
        }
        TaskSharedStorageAccess taskSSAccess = new TaskSharedStorageAccess(this.m_genTask.m_nodeList);
        String[] fileSystemList = new String[]{this.m_genTask.m_fileSystem};
        taskSSAccess.setStorageIDlist(fileSystemList);
        taskSSAccess.setCheckOCFS(true);
        boolean ssaStatus = taskSSAccess.performTask();
        ResultSet ssaRset = taskSSAccess.getResultSet();
        Trace.out((String)"==== Uploading results from ssaRset");
        this.m_genTask.m_resultSet.uploadResultSet(ssaRset);
        return this.m_genTask.m_resultSet.allSuccess();
    }

    private String getHostGuid(String guid) {
        String hostGuid = null;
        Trace.out((String)("==== Trying to extract host-guid from: " + guid));
        boolean bMatched = Pattern.matches(".*guid = .*", guid);
        if (bMatched) {
            hostGuid = guid.substring(guid.length() * 10 / 16);
        }
        return hostGuid;
    }

    private boolean checkRunLevel(String chkCfgTxt, String[] cfgRes) {
        boolean chkFailed = false;
        Trace.out((String)("==== Parsing run-level output '" + chkCfgTxt + "'"));
        for (int i = 3; i < 6; ++i) {
            if (-1 != chkCfgTxt.indexOf(i + ":on")) {
                cfgRes[i - 3] = ReportUtil.ON;
                continue;
            }
            if (-1 != chkCfgTxt.indexOf(i + ":off")) {
                cfgRes[i - 3] = ReportUtil.OFF;
                chkFailed = true;
                continue;
            }
            cfgRes[i - 3] = ReportUtil.UNKNOWN;
            chkFailed = true;
        }
        return !chkFailed;
    }
}

